# 虚拟哪吒探针 (Virtual Nezha Agent)

[![Go Version](https://img.shields.io/badge/Go-%3E%3D1.21-blue?logo=go)](https://golang.org/)
[![License](https://img.shields.io/badge/License-AGPL%20v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)
[![Release](https://img.shields.io/github/v/release/narwhal-cloud/virtual-nezha-agent?logo=github)](https://github.com/narwhal-cloud/virtual-nezha-agent/releases)

一个用于 [哪吒监控](https://github.com/naiba/nezha) 系统的虚拟Agent生成器。可以模拟多个服务器节点，生成真实的系统监控数据，用于测试、演示或负载测试场景。

## ✨ 特性

- 🖥️ **简洁的Web管理界面** - 通过浏览器轻松管理虚拟节点
- 🌍 **地理位置模拟** - 支持全球200+国家/地区的IP地址模拟
- 📊 **真实数据仿真** - 多种负载等级系统指标
- 🔄 **智能重连机制** - 自动处理连接断开和重连
- 🎛️ **灵活配置** - 支持自定义CPU、内存、磁盘等硬件规格
- 🔒 **SSL/TLS支持** - 支持安全连接到监控服务器

## 🚀 快速开始

### 环境要求

- Go 1.21 或更高版本
- 一个运行中的哪吒监控服务器

### 安装部署

#### 方式一：直接运行

```bash
# 克隆项目
git clone https://github.com/narwhal-cloud/virtual-nezha-agent.git
cd virtual-nezha-agent

# 安装依赖
go mod tidy

# 启动服务
go run .
```

#### 方式二：编译后运行

```bash
# 编译
go build -o virtual-nezha-agent

# 运行
./virtual-nezha-agent
```

### 访问管理界面

启动成功后，在浏览器中访问：
```
http://localhost:5484
```

## 📖 使用说明

### 创建虚拟节点

1. 在Web界面中填写以下信息：
   - **服务器地址**: 你的哪吒监控服务器地址 (例如: `monitor.example.com:5555`)
   - **客户端密钥**: 在哪吒面板中生成的客户端密钥
   - **Client UUID**: 自动生成的唯一标识符（可重新生成）
   - **国家代码**: 两位国家代码 (如: `CN`, `US`, `JP`)
   - **硬件配置**: CPU型号、核心数、内存大小等

2. 选择负载等级：
   - **低负载**: CPU(5-30%), 内存(20-50%), 网络(128KB/s-2MB/s)
   - **中等负载**: CPU(30-70%), 内存(40-75%), 网络(2MB/s-10MB/s)  
   - **高负载**: CPU(60-95%), 内存(70-90%), 网络(10MB/s-100MB/s)

3. 点击"创建 Agent"按钮

## 📄 许可证

本项目使用 [GNU Affero General Public License v3.0](LICENSE) 许可证。

## 问题反馈

- [GitHub Issues](https://github.com/narwhal-cloud/virtual-nezha-agent/issues)

---

如果这个项目对你有帮助，请给它一个⭐️！
