// 虚拟Nezha Agent - 用于模拟Nezha监控系统的客户端代理
// 提供Web界面管理多个虚拟Agent实例，可模拟不同的系统负载和地理位置
package main

import (
	_ "embed"
	"flag"
	"fmt"
	"log"
	"net/http"
	"virtual-nezha-agent/pkg/handler"
	"virtual-nezha-agent/pkg/manager"

	"github.com/gorilla/mux"
)

//go:embed index.html
var indexHTML string

func main() {
	port := flag.Uint("port", 12580, "server port")
	// 创建Agent管理器
	agentManager := manager.New()

	// 创建HTTP处理器
	h := handler.New(agentManager, indexHTML)

	// 创建HTTP路由
	router := mux.NewRouter()
	apiRouter := router.PathPrefix("/api/v1").Subrouter()

	// Agent相关路由
	apiRouter.HandleFunc("/agents", h.CreateAgent).Methods("POST")
	apiRouter.HandleFunc("/agents", h.GetAgents).Methods("GET")
	apiRouter.HandleFunc("/agents/{id}", h.GetAgent).Methods("GET")
	apiRouter.HandleFunc("/agents/{id}", h.UpdateAgent).Methods("PUT")
	apiRouter.HandleFunc("/agents/{id}", h.DeleteAgent).Methods("DELETE")

	// 静态文件服务 - 主页
	router.HandleFunc("/", h.Index).Methods("GET")

	// 启动HTTP服务器

	log.Printf("Agent Web API 服务已启动，监听端口: %d", *port)
	log.Printf("界面: http://localhost:%d/", *port)

	if err := http.ListenAndServe(fmt.Sprintf(":%d", *port), router); err != nil {
		log.Fatalf("HTTP服务器启动失败: %v", err)
	}
}
