package agent

import "virtual-nezha-agent/config"

func GetLoadLevelConfig(level string) (config.UsageConfig, config.UsageConfig, config.UsageConfig) {
	switch level {
	case "low":
		return config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    5.0,
				Max:    30.0,
				Base:   15.0,
				Period: 120,
			}, config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    20.0,
				Max:    50.0,
				Base:   35.0,
				Period: 180,
			}, config.UsageConfig{
				Mode: config.SimulationLinear,
				Min:  10.0,
				Max:  40.0,
				Base: 20.0,
				Step: 0.02,
			}
	case "high":
		return config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    60.0,
				Max:    95.0,
				Base:   75.0,
				Period: 120,
			}, config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    70.0,
				Max:    90.0,
				Base:   80.0,
				Period: 180,
			}, config.UsageConfig{
				Mode: config.SimulationLinear,
				Min:  60.0,
				Max:  85.0,
				Base: 70.0,
				Step: 0.05,
			}
	default: // medium
		return config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    30.0,
				Max:    70.0,
				Base:   50.0,
				Period: 120,
			}, config.UsageConfig{
				Mode:   config.SimulationWave,
				Min:    40.0,
				Max:    75.0,
				Base:   55.0,
				Period: 180,
			}, config.UsageConfig{
				Mode: config.SimulationLinear,
				Min:  30.0,
				Max:  65.0,
				Base: 45.0,
				Step: 0.03,
			}
	}
}

func GetNetworkLoadLevelConfig(level string) config.NetworkConfig {
	switch level {
	case "low":
		return config.NetworkConfig{
			InSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      128 * 1024,
				Max:      2 * 1024 * 1024,
				Variance: 512 * 1024,
			},
			OutSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      64 * 1024,
				Max:      1024 * 1024,
				Variance: 256 * 1024,
			},
			InTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 128 * 1024,
			},
			OutTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 64 * 1024,
			},
		}
	case "high":
		return config.NetworkConfig{
			InSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      10 * 1024 * 1024,
				Max:      100 * 1024 * 1024,
				Variance: 20 * 1024 * 1024,
			},
			OutSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      5 * 1024 * 1024,
				Max:      50 * 1024 * 1024,
				Variance: 10 * 1024 * 1024,
			},
			InTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 2 * 1024 * 1024,
			},
			OutTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 1024 * 1024,
			},
		}
	default: // medium
		return config.NetworkConfig{
			InSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      2 * 1024 * 1024,
				Max:      10 * 1024 * 1024,
				Variance: 2 * 1024 * 1024,
			},
			OutSpeed: config.UsageConfig{
				Mode:     config.SimulationRandom,
				Min:      1024 * 1024,
				Max:      5 * 1024 * 1024,
				Variance: 1024 * 1024,
			},
			InTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 512 * 1024,
			},
			OutTotal: config.UsageConfig{
				Mode: config.SimulationLinear,
				Base: 0,
				Step: 256 * 1024,
			},
		}
	}
}

func GetSystemLoadLevelConfig(level string) config.LoadConfig {
	switch level {
	case "low":
		return config.LoadConfig{
			Load1: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.05,
				Max:      0.8,
				Period:   300,
				Variance: 0.1,
			},
			Load5: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.1,
				Max:      0.7,
				Period:   900,
				Variance: 0.08,
			},
			Load15: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.15,
				Max:      0.6,
				Period:   1800,
				Variance: 0.05,
			},
		}
	case "high":
		return config.LoadConfig{
			Load1: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      2.0,
				Max:      8.0,
				Period:   300,
				Variance: 1.0,
			},
			Load5: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      1.8,
				Max:      6.0,
				Period:   900,
				Variance: 0.8,
			},
			Load15: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      1.5,
				Max:      4.0,
				Period:   1800,
				Variance: 0.5,
			},
		}
	default: // medium
		return config.LoadConfig{
			Load1: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.5,
				Max:      3.0,
				Period:   300,
				Variance: 0.4,
			},
			Load5: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.4,
				Max:      2.5,
				Period:   900,
				Variance: 0.3,
			},
			Load15: config.UsageConfig{
				Mode:     config.SimulationWave,
				Min:      0.3,
				Max:      2.0,
				Period:   1800,
				Variance: 0.2,
			},
		}
	}
}
